<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2016 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CSeo extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		parent::DoEvents();
	}



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PageMeta($item , $remove_key = "" , $force = false) {
		global $_TSM , $_CONF;

		if ($remove_key) {

			foreach ($item as $key => $val) {
				if (stristr($key , $remove_key)) {
					$_item[str_replace($remove_key , "" , $key)] = $val;
				}				
			}
			
			$item = $_item;
		}

		if ( ($item["seo_title"] && !$_TSM["PUB:SEO_TITLE"]) || $force);
			$_TSM["PUB:SEO_TITLE"] = $item["seo_title"];

		if (($item["seo_desc"] && !$_TSM["PUB:SEO_DESC"])  || $force);
			$_TSM["PUB:SEO_DESC"] = $item["seo_desc"];
		
		if ($item["seo_conv_head"] && !$_TSM["PUB:SEO_CONV_HEAD"])
			$this->AppendToHead($item["seo_conv_head"]);
	

		if ($item["seo_meta"] && !$_TSM["PUB:SEO_META"]) {
			$this->AppendToHead("\t\t<meta name=\"robots\" content=\"{$item[seo_meta]}\">");

			//set xroboots
			header("X-Robots-Tag: {$item[seo_meta]}");
		}


		if ($item["seo_conv_body"])
			$_TSM["PUB:SEO_CONV_BODY"] .= $item["seo_conv_body"];


		if ($item["canonical"]) {
			$this->Canonical($item["canonical"]);
		}
		
		if ($item["next_page"]) {
			$this->NextPage($item["next_page"]);
		}

		if ($item["prev_page"]) {
			$this->NextPage($item["prev_page"]);
		}


		$url = $item["canonical"] ? $item["canonical"] : substr($_CONF["url"] ,0 , -1) . $_SERVER["REDIRECT_URL"];

		$this->OpenGraph(array(
			"og:type"			=> "website",
			"og:title"			=> $item["seo_title"],
			"og:description"	=> $item["seo_desc"],
			"og:url"			=> $item["canonical"] ,
			"og:image"			=> "",
			"og:image:secure_url"	=> "",

			"twitter:card"		=> "summary",
			"twitter:title"		=> $item["seo_title"],
			"twitter:image"		=> $item["seo_desc"],
			"twitter:site"		=> "",
		));

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AppedToHead($info) {
		$this->AppendToHead($info);
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AppendToHead($info) {
		global $_TSM;

		$_TSM["PUB:SEO_CONV_HEAD"] .= $info . "\n";
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AddStylesheet($link , $media="") {
		$this->AppendToHead("\t\t<link rel=\"stylesheet\" href=\"{$link}\" media=\"{$media}\">");
	}
	
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function AppedToBody($info) {
		$this->AppendToBody($info);
	}

	function PrependToBody($info) {
		global $_TSM;

		$_TSM["PUB:SEO_CONV_BODYHEAD"] .= $info;

	}
	
	function AppendToBody($info) {
		global $_TSM;

		$_TSM["PUB:SEO_CONV_BODY"] .= $info;

	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function NextPage($link) {
		global $_TSM;
		$this->AppendToHead('\t\t<link rel="next" href="' . $link . '" />');
	}
	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PrevPage($link) {
		global $_TSM;
		$this->AppendToHead('\t\t<link rel="prev" href="' . $link . '" />');
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Canonical($link) {
		global $_TSM;
		$this->appendToHead("\t\t<link rel=\"canonical\" href=\"" . $link . "\" />");

		$this->OpenGraph(array(
			"og:url"			=> $item["canonical"] ,
		));

	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function BreadCrumb($links) {

		$data = array(
			"@context"	=> "http://schema.org",
			"@type"		=> "BreadcrumbList",
			"itemListElement" => array(
			)
		);


		if (is_array($links)) {
			$pos = 1;

			foreach ($links as $key => $val) {
				$data["itemListElement"][] = array(
					"@type"		=> "ListItem",
					"position"	=> $pos,
					"item"		=> array(

						"@id"		=> $val["link"],
						"name"		=> $val["name"]
					)
				);

				$pos++;
			}			
		}
		
		
		$this->appendToHead('<script type="application/ld+json">' . json_encode($data) . '</script>');

	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function SocialSchema($links) {
		global $_CONF;
		$data = array(
			"@context"	=> "http://schema.org",
			"@type"		=> "Organization",
			"url"		=> $_CONF["url"],
			"logo"		=> $_CONF["url"] . "upload/logo.png",
			"sameAs"	=> $links
		);


		$this->appendToHead('<script type="application/ld+json">' . json_encode($data) . '</script>');		
	}
	

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function OpenGraph($meta = array()) {	

		if (is_array($meta)) {
			foreach ($meta as $key => $val) {
				if ($val) {

					if (($key == "og:image") && $this->og[$key]) {

						if (!is_array($this->og[$key])) {
							$this->og[$key] = array(
								$this->og[$key]
							);
						}

						$this->og[$key][] = $val;						
					} else {					
						$this->og[$key] = $val;
					}
				}				
			}			
		}		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function OpenGraphRender() {
		global $_CONF;

		//check for fallback
		$fallback = array(
			"og:title"			=> $this->vars->data["set_og_title"],
			"og:description"	=> $this->vars->data["set_og_description"],
			"og:site_name"		=> $this->vars->data["set_og_site"],
			"og:image"			=> $this->vars->data["set_og_img"] ? $_CONF["url"] . "upload/og.png" : "",

			"twitter:site"		=> $this->vars->data["set_tw_site"],
			"twitter:creator"	=> $this->vars->data["set_tw_creator"],
		);


		//twitter settings

		foreach ($fallback as $key => $val) {
			if (!$this->og[$key]) {
				$this->og[$key] = $val;
			}
		}

/*
<meta property="article:publisher" content="link" />
<meta property="article:section" content="Some Section" />
<meta property="article:published_time" content="2017-05-31T07:30:40-04:00" />
<meta property="article:modified_time" content="2017-06-26T10:36:47-04:00" />
<meta property="og:updated_time" content="2017-06-26T10:36:47-04:00" />


*/
		
		$this->og["twitter:card"]			= "summary";
		$this->og["twitter:title"]			= $this->og["og:title"];
		$this->og["twitter:description"]	= $this->og["og:description"];
		$this->og["twitter:image"]			= $this->og["og:image"];

		if ($this->vars->data["set_facebook_app"]) {	
			$this->og["fb:app_id"]				= $this->vars->data["set_facebook_app"];
		}
		
		if (is_array($this->og)) {
			foreach ($this->og as $key => $val) {
				if ($val) {

					if (is_Array($val)) {
						foreach ($val as $k => $v) {

							$this->AppendToHead("\t\t<meta property=\"{$key}\" content=\"{$v}\" />");
						}						
					} else {					
						$this->AppendToHead("\t\t<meta property=\"{$key}\" content=\"{$val}\" />");
					}
				}				
			}			
		}		
	}
	
	
		
}

?>